#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
        # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE"
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

SYSTEM_INFOS=`cat /etc/issue 2> /dev/null`
redhat_version=`cat /etc/redhat-release 2> /dev/null`

if [ "${redhat_version}" != "" ] ; then
    echo "=> system version: ${redhat_version}"
elif [ "${SYSTEM_INFOS}" != "" ] ; then
    echo "=> system version: ${SYSTEM_INFOS}"
else
    echo "=> system version: unknown"
fi

if [ -f /usr/lib/libstdc++.so.6 ] ; then
    LIBC_VERSION=`strings /usr/lib/libstdc++.so.6 | grep -E "^GLIBC_[0-9.]+"`
    echo "=> libcxx version:"
    for x in  ${LIBC_VERSION}
    do
        echo "    $x"
    done
fi

if [ -f /usr/lib64/libstdc++.so.6 ] ; then
    LIBC_VERSION=`strings /usr/lib64/libstdc++.so.6 | grep -E "^GLIBC_[0-9.]+"`
    echo "=> libcxx version:"
    for x in  ${LIBC_VERSION}
    do
        echo "    $x"
    done
fi

if [ -f /lib64/libc.so.6 ] ; then
    LIBC_VERSION=`strings /lib64/libc.so.6 | grep -E "^GLIBC_[0-9.]+"`
    echo "=> libc version:"
    for x in  ${LIBC_VERSION}
    do
        echo "    $x"
    done
fi

if [ -f /lib/x86_64-linux-gnu/libc.so.6 ] ; then
    LIBC_VERSION=`strings /lib/x86_64-linux-gnu/libc.so.6 | grep -E "^GLIBC_[0-9.]+"`
    echo "=> libc version:"
    for x in  ${LIBC_VERSION}
    do
        echo "    $x"
    done
fi

KERNEL_VERSION=`uname -r`
echo "=> kernel version: ${KERNEL_VERSION}"
