#!/usr/bin/env bash

SOURCE="$0"

while [ -h "$SOURCE"  ]; do
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
    # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE"
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

cd ${DIR}

echo "uninstall sniper kernel log patch!"
if [ -f sniperknl-patch/uninstall-sniperknl-logger.sh ] ; then
    chmod +x sniperknl-patch/uninstall-sniperknl-logger.sh
    cd sniperknl-patch
    ./uninstall-sniperknl-logger.sh
    cd ${DIR}
fi