#!/usr/bin/env bash

source ./utils.sh

system_infos=`cat /etc/issue 2> /dev/null`

function like() {
    local match_result=`echo "$1" | grep "$2" | wc -l | awk '{print $1}'`
    [ "$match_result" == "1" ]
}

function handle_sniperknl_exception() {
    # 安装补丁前检测日志是否异常，如果日志文件已经超过100M就删除，避免过多占用磁盘空间
    max_size=104857600
    if [ -f /var/log/sniperknl.log ] ; then
        current_size=`ls -l /var/log/sniperknl.log | awk '{print $5}'`
    else
        current_size=0
    fi
    
    if [ $current_size -gt $max_size ]; then
        rm -f /var/log/sniperknl.log
        systemctl_service rsyslog restart
        echo "The sniperknl.log file has exceeded 100M. Delete it"
        logger "The sniperknl.log file has exceeded 100M. Delete it"
    fi
}

function config_sniperknl_log() {
    if [ ! -d /usr/local/sniper ] ; then
        echo "You need to install the sniper client."
        exit 1
    fi 
    chmod +x sniperknl-*
    chmod +x *.sh
    
    cp sniperknl-crontab-script.sh /usr/local/sniper
    cp sniperknl-logrotate-report.sh /usr/local/sniper
    cp utils.sh /usr/local/sniper

	chmod 0600 sniperknl-logrotate
    mkdir -p /etc/rsyslog.d/ /etc/logrotate.d/
    cp sniperknl-rsyslog.conf /etc/rsyslog.d/
    cp sniperknl-logrotate /etc/logrotate.d/
    systemctl_service rsyslog restart
    
    # 添加定时任务
    mkdir -p /etc/cron.d/
    cp sniperknl-crontab /etc/cron.d/
    chmod 0600 /etc/cron.d/sniperknl-crontab
    if like "$system_infos" "Ubuntu" || like "$system_infos" "Debian" ; then
        update-rc.d cron defaults
        systemctl_service cron restart
    else
        chkconfig crond on
        systemctl_service crond restart
    fi    
}

function remove_big_files() {
    for file in $(find /usr/local/sniper/logs -type f 2>/dev/null)
    do
    file_size=`stat ${file} | grep Size | awk '{print $2}'`
    echo "${file} size: ${file_size} byte!"
    if [ $file_size -gt 2097152 ] ; then
        rm -rf ${file}
        echo "rm -rf '${file}'"
    fi 
    done
}

function config_client_log() {
    echo "upgrade the client's logger configuration file ..."
    if [ ! -d /usr/local/sniper ] ; then
        echo "You need to install the sniper client."
        exit 1
    fi

    # 替换日志配置文件
    cp client-logger-config/edr3-logger.conf /usr/local/sniper/config
    cp client-logger-config/edr3-upgrade-logger.conf /usr/local/sniper/config
    
    # 重启客户端
    echo "stop the sniper client ..."
    /usr/local/sniper/shutdown.sh
    sniper_pid=`ps -ef | grep sniper | grep -v grep | grep -v sniperknl`
    if [ "#${sniper_pid}" == "#" ] ;  then
        echo "sniper client is stop."
    else
        echo "stop the client failed!!!"
    fi

    echo "start the sniper client ..."
    /usr/local/sniper/startup.sh
    sniper_pid=`ps -ef | grep sniper | grep -v grep | grep -v sniperknl`
    if [ "#${sniper_pid}" == "#" ] ;  then
        echo "start the client failed!!!"
    else
        echo "sniper client pid: ${sniper_pid}"
    fi

    # 检测
    remove_big_files
    echo "sniper logs: `ls -lh /usr/local/sniper/logs`"
}

handle_sniperknl_exception
config_sniperknl_log
# config_client_log
