#!/usr/bin/env bash
SOURCE="$0"
# set -x

while [ -h "$SOURCE"  ]; do 
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
    # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE" 
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

SNIPER_PATH=/usr/local/sniper
if [ ! -d $SNIPER_PATH ] ; then
    SNIPER_PATH=$DIR
fi

if [ ! -f $SNIPER_PATH/sniper ] ; then
    echo "=> command not found $SNIPER_PATH/sniper"
    exit 1
fi

# 设置环境变量，如果应用层发现coredump，则生成core文件
ulimit -c unlimited

cd $SNIPER_PATH
# 检查环境变量，如果不存在则设置环境变量，避免upgrade在启动是，不能发现启动问题
echo $PATH | grep -q "/usr/local/sbin/"

if [ ! $? -eq 0 ]; then
  PATH=$PATH:/usr/local/sbin/
  export PATH
else
  export PATH
fi
logger "sniper runing path: $PATH"

echo "starup sniper ..."
./sniper -d -o start
